/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.network;

import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.impl.network.RequestHandler;
import io.gitlab.jfronny.libjf.config.impl.network.ResponseHandler;
import io.gitlab.jfronny.libjf.config.impl.network.packet.ConfigurationCompletePacket;
import io.gitlab.jfronny.libjf.config.impl.network.packet.ConfigurationPacket;
import io.gitlab.jfronny.libjf.config.impl.network.packet.RequestPacket;
import io.gitlab.jfronny.libjf.config.impl.network.packet.ResponsePacket;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;

public class RequestRouter {
    public static final String MOD_ID = "libjf-config-network-v0";
    public static int PROTOCOL_VERSION = 1;
    private static final Map<String, RequestHandler> persistendHandlers = new HashMap<String, RequestHandler>();
    private static final Map<Long, Request> currentRequests = new HashMap<Long, Request>();
    private static final Random random = new Random();

    public static void initialize() {
        PayloadTypeRegistry.playC2S().register(RequestPacket.ID, RequestPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(RequestPacket.ID, RequestPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(ResponsePacket.ID, ResponsePacket.CODEC);
        PayloadTypeRegistry.playS2C().register(ResponsePacket.ID, ResponsePacket.CODEC);
        PayloadTypeRegistry.configurationS2C().register(ConfigurationPacket.ID, ConfigurationPacket.CODEC);
        PayloadTypeRegistry.configurationC2S().register(ConfigurationCompletePacket.ID, ConfigurationCompletePacket.CODEC);
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void acceptResponse(ResponsePacket response, PacketSender responseSender) {
        Request request = currentRequests.remove(response.request());
        if (request != null) {
            switch (response.status()) {
                case 0: {
                    request.responseHandler.onSuccess(response.aux());
                    break;
                }
                case 1: {
                    request.responseHandler.onNotFound();
                    break;
                }
                case 2: {
                    request.responseHandler.onDeny();
                    break;
                }
                case 3: {
                    request.responseHandler.onFailure(response.aux().method_19772());
                    break;
                }
                default: {
                    request.responseHandler.onFailure("Unrecognized error received");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acceptRequest(RequestPacket request, PacketSender responseSender) {
        long id = request.request();
        int mode = 3;
        class_2540 aux = PacketByteBufs.create();
        try {
            if (request.parent() == null) {
                mode = RequestRouter.handleRequest((ByteBuf)aux, id, request.aux(), persistendHandlers.get(request.name()));
            } else {
                Request parent = currentRequests.get(request.parent());
                if (parent == null) {
                    mode = 1;
                } else {
                    String key = request.name();
                    RequestHandler handler = parent.temporaryHandlers.get(key);
                    if (handler == null) {
                        handler = persistendHandlers.get(key);
                    }
                    mode = RequestRouter.handleRequest((ByteBuf)aux, id, request.aux(), handler);
                }
            }
        }
        catch (Throwable t) {
            LibJf.LOGGER.error("Cannot complete request", t);
            aux.method_52931();
            aux.method_10814(t.getMessage() == null ? "null" : t.getMessage());
        }
        finally {
            responseSender.sendPacket((class_8710)new ResponsePacket(id, mode, aux));
        }
    }

    private static int handleRequest(ByteBuf aux, long id, class_2540 buf, RequestHandler handler) throws Throwable {
        if (handler == null) {
            return 1;
        }
        class_2540 response = handler.handle(buf, (responseSender, name, body, responseHandler, temporaryHandlers) -> RequestRouter.sendRequest(responseSender, id, name, body, responseHandler, temporaryHandlers));
        if (response != null) {
            aux.writeBytes(response.copy());
        }
        return 0;
    }

    public static void deny(long id, PacketSender responseSender) {
        responseSender.sendPacket((class_8710)new ResponsePacket(id, 2, PacketByteBufs.empty()));
    }

    public static void registerHandler(String name, RequestHandler handler) {
        persistendHandlers.put(name, handler);
    }

    public static void sendRequest(PacketSender responseSender, String name, class_2540 body, ResponseHandler responseHandler, Map<String, RequestHandler> temporaryHandlers) {
        RequestRouter.sendRequest(responseSender, null, name, body, responseHandler, temporaryHandlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendRequest(PacketSender responseSender, Long parent, String name, class_2540 body, ResponseHandler responseHandler, Map<String, RequestHandler> temporaryHandlers) {
        long id;
        Map<Long, Request> map = currentRequests;
        synchronized (map) {
            Set<Long> keys = currentRequests.keySet();
            while (keys.contains(id = random.nextLong())) {
            }
            currentRequests.put(id, new Request(temporaryHandlers, responseHandler));
        }
        responseSender.sendPacket((class_8710)new RequestPacket(id, parent, name, body == null ? PacketByteBufs.empty() : PacketByteBufs.copy((ByteBuf)body)));
    }

    private record Request(Map<String, RequestHandler> temporaryHandlers, ResponseHandler responseHandler) {
    }
}

